# Draw the underlying screen without the user drawn objects

import pygame
from Button import *
from Stack import *
from Paint import *
from Mode import *

import math

# Draw all of the basic screen elements - buttons and such
def background():
    global current_color, screen, BLACK, textSurface

# Draw the basic window regions
    pygame.draw.line(screen, BLACK, (0, 600), (800, 600), 2)
    pygame.draw.line(screen, BLACK, (800, 0), (800, 600), 2)
    pygame.draw.line(screen, BLACK, (0, 0), (1000, 0), 2)
    pygame.draw.line(screen, BLACK, (1000, 0), (1000, 700), 2)
    pygame.draw.line(screen, BLACK, (1000, 700), (0, 700), 2)
    pygame.draw.line(screen, BLACK, (0, 700), (0, 0), 2)
    screen.blit(textsurface, (50, 630))

# Draw all of the buttons
    lineButton.draw()
    circleButton.draw()
    rectButton.draw()
    textButton.draw ()
    eraseButton.draw()
    saveButton.draw()
    thick1Button.draw()
    thick2Button.draw()
    thick3Button.draw()
    backButton.draw()
    foreButton.draw()
    blackButton.draw()
    redButton.draw()
    greenButton.draw()
    blueButton.draw()
    cyanButton.draw()
    yellowButton.draw()
    magentaButton.draw()
    greyButton.draw()
    whiteButton.draw()
    if currentColor == (255,255,255):   # Draw a box with the current color
        pygame.draw.rect(screen, currentColor, pygame.Rect(700, 630, 50, 50), 1)
    else:
        pygame.draw.rect(screen, currentColor, pygame.Rect(700, 630, 50, 50))
    if mouseX<=800 and mouseY <= 600:   # Draw the X coordinate of the mouse
        tempsurface = myfont.render(str(mouseX), False, (0, 0, 0))
        screen.blit(tempsurface, (90, 630))
        tempsurface = myfont.render(str(mouseY), False, (0, 0, 0))
        screen.blit(tempsurface, (200, 630))
# RGB of the current color
    tempsurface = myfont.render(str(currentColor[0]), False, (0, 0, 0))
    screen.blit(tempsurface, (380, 630))
    tempsurface = myfont.render(str(currentColor[1]), False, (0, 0, 0))
    screen.blit(tempsurface, (490, 630))
    tempsurface = myfont.render(str(currentColor[2]), False, (0, 0, 0))
    screen.blit(tempsurface, (600, 630))

def checkButtons():
    global mode, currentColor, thickness
    if lineButton.armed():
        mode = LINE
    elif circleButton.armed():
        mode = CIRCLE
    elif rectButton.armed():
        mode = RECTANGLE
    elif textButton.armed():
        mode = TEXT
    elif eraseButton.armed():
        mode = ERASE
    elif thick1Button.armed():
        thickness = 1
    elif thick2Button.armed():
        thickness = 2
    elif thick3Button.armed():
        thickness = 4
    elif saveButton.armed():
        save()
    elif backButton.armed():
        pushState()
    elif foreButton.armed():
        popState()
    elif blackButton.armed():
        currentColor = (0,0,0)
    elif redButton.armed():
        currentColor = (255,0,0)
    elif blueButton.armed():
        currentColor = (0,0,255)
    elif greenButton.armed():
        currentColor = (0,255,0)
    elif cyanButton.armed():
        currentColor = (0,255,255)
    elif yellowButton.armed():
        currentColor = (255,255,0)
    elif magentaButton.armed():
        currentColor = (255, 0, 255)
    elif greyButton.armed():
        currentColor = (200,200,200)
    elif whiteButton.armed():
        currentColor = (255,255,255)

def distance (a, b):
    r = (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])
    return math.sqrt (r)

def redraw():
    for i in range (0, backstack.N):
        op = backstack.get(i)
        a = op.getstart()
        b = op.getend()
        k = op.getkind()
        print ("Redraw ", op.getkind(), a, b)
        if k == LINE:
            pygame.draw.line (screen, currentColor, (a[0],a[1]), (b[0],b[1]), thickness)
        elif  k == CIRCLE:
            pygame.draw.circle(screen, currentColor, (a[0],a[1]), round(distance(a, b)), thickness)
        elif k == RECTANGLE:
            pygame.draw.rect(screen, currentColor, (a[0],a[1], b[0]-a[0], b[1]-a[1]), thickness)
        elif k == TEXT:
            pass
        elif k == ERASE:
            pygame.draw.rect(screen, currentColor, (a[0],a[1], b[0]-a[0], b[1]-a[1]), 1)

def save ():
    pygame.image.save (screen, "out.png")

screen = pygame.display.set_mode((1000, 700))  # Notice the tuple! It's not 2 arguments.
clock = pygame.time.Clock()
pygame.font.init()
myfont = pygame.font.SysFont('Comic Sans MS', 30)
textsurface = myfont.render('X          Y                   R          G          B', False, (0, 0, 0))

FPS = 60  # This variable will define how many frames we update per second.
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
#rect = pygame.Rect((0, 0), (32, 32))

# Initialize the images for the buttons
imageLine = pygame.Surface((42, 42))            # Draw line
imageLine.fill((200,200,200))
pygame.draw.line (imageLine, BLACK, (3,3), (38,38), 2)
imageT1 = pygame.Surface((42, 42))  # Line size 1
imageT1.fill ((200,200,200))
pygame.draw.line (imageT1, BLACK, (3,21), (38,21), 1)
imageT2 = pygame.Surface((42, 42))  # Line size 2
imageT2.fill ((200,200,200))
pygame.draw.line (imageT2, BLACK, (3,21), (38,21), 2)
imageT3 = pygame.Surface((42, 42))  # Line size 3
imageT3.fill ((200,200,200))
pygame.draw.line (imageT3, BLACK, (3,21), (38,21), 4)
imageCircle = pygame.Surface((42, 42))
imageCircle.fill((200,200,200))
pygame.draw.circle(imageCircle, BLACK, (20,20), 10, 2)
imageRect = pygame.Surface ((42,42))
imageRect.fill((200,200,200))
pygame.draw.rect(imageRect, BLACK, (12,12, 18,18), 2)
imageErase = pygame.image.load ("erase.png")
imageSave = pygame.image.load ("save.png")
imageBack = pygame.image.load ("back.png")
imageFore = pygame.image.load ("fore.png")
imageText = pygame.image.load ("text.png")
# Initialize all of the buttons
lineButton   = Button (screen, 825, 20, 50, 50)
lineButton.set_image (imageLine)
circleButton = Button (screen, 825, 80, 50, 50)
circleButton.set_image (imageCircle)
rectButton   = Button (screen, 825, 140, 50, 50)
rectButton.set_image (imageRect)
textButton   = Button (screen, 825, 200, 50, 50)
textButton.set_image (imageText)
eraseButton  = Button (screen, 825, 260, 50, 50)
eraseButton.set_image (imageErase)
thick1Button = Button (screen, 825, 320, 50, 50)
thick1Button.set_image (imageT1)
thick2Button = Button (screen, 825, 380, 50, 50)
thick2Button.set_image (imageT2)
thick3Button = Button (screen, 825, 440, 50, 50)
thick3Button.set_image (imageT3)
saveButton   = Button (screen, 825, 500, 50, 50)
saveButton.set_image (imageSave)
backButton   = Button (screen, 885, 20, 50, 50)
backButton.set_image (imageBack)
foreButton = Button (screen, 885, 80, 50, 50)
foreButton.set_image (imageFore)
blackButton   = Button (screen, 885, 140, 50, 50)
blackButton.set_color (BLACK)
redButton   = Button (screen, 885, 200, 50, 50)
redButton.set_color ((255, 0, 0))
greenButton  = Button (screen, 885, 260, 50, 50)
greenButton.set_color ((0, 250, 0))
blueButton = Button (screen, 885, 320, 50, 50)
blueButton.set_color ((0,0,255))
cyanButton = Button (screen, 885, 380, 50, 50)
cyanButton.set_color ((0, 250, 250))
yellowButton = Button (screen, 885, 440, 50, 50)
yellowButton.set_color ((255, 255, 0))
magentaButton = Button (screen, 885, 500, 50, 50)
magentaButton.set_color ((255, 0, 255))
greyButton   = Button (screen, 885, 560, 50, 50)
greyButton.set_color ((200,200,200))
whiteButton   = Button (screen, 885, 620, 50, 50)
whiteButton.set_color (WHITE)
currentColor = (0,0,0)

thickness = 1
LINE = 100
CIRCLE = 101
RECTANGLE = 102
TEXT = 103
ERASE = 104
mode = LINE
mouseDownX = 0
mouseDownY = 0
mouseUpX = 0
mouseUpY = 0
backstack = Stack()
foreStack = Stack()
down = False

while True:
    clock.tick(FPS)
    mouze = pygame.mouse.get_pos()
    mouseX = mouze[0]
    mouseY = mouze[1]
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()
        if event.type == pygame.MOUSEBUTTONDOWN and not down:
            print ("Down at ", mouseX, " ", mouseY)
            mouseDownX = mouseX
            mouseDownY = mouseY
            down = True
            thisdraw = Mode (mode, [mouseDownX,mouseDownY], [mouseDownX,mouseDownY])
            backstack.push(thisdraw)
        elif down:
            if mode == LINE:
                old = backstack.top().setend([mouseX,mouseY])
            elif mode == CIRCLE:
                old = backstack.top().setend([mouseX,mouseY])
            elif mode == RECTANGLE:
                old = backstack.top().setend([mouseX,mouseY])
            elif mode == ERASE:
                old = backstack.top().setend([mouseX,mouseY])
        if event.type == pygame.MOUSEBUTTONUP:     # Mouse button was released
            down = False
            if checkButtons():
                continue
            if mode == TEXT:
                ts = gettext()
                thisdraw = Mode (TEXT, [mouseX,mouseY], ts)
            else:
                old = backstack.top().print()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_w:
                rect.move_ip(0, -2)  # Changes the rect's position.
            elif event.key == pygame.K_s:
                rect.move_ip(0, 2)
            elif event.key == pygame.K_a:
                rect.move_ip(-2, 0)
            elif event.key == pygame.K_d:
                rect.move_ip(2, 0)

    screen.fill(WHITE)
    background ()            # Draw the paint window
    redraw()
    pygame.display.update()  # redraw the screen
